/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.authn.OidcClientSecretJwtAuthenticator;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.util.EncodingUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.AesKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oauth.code.time-to-kill-in-seconds=60"})
public class OidcClientSecretJwtAuthenticatorTests
extends AbstractOidcTests {
    @Test
    public void verifyBadAlgAction() throws Exception {
        OidcClientSecretJwtAuthenticator auth = new OidcClientSecretJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String audience = this.casProperties.getServer().getPrefix().concat("/oidc/oidcAccessToken");
        OidcRegisteredService registeredService = OidcClientSecretJwtAuthenticatorTests.getOidcRegisteredService();
        JwtClaims claims = this.getClaims(registeredService.getClientId(), registeredService.getClientId(), registeredService.getClientId(), audience);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey priv = pair.getPrivate();
        byte[] jwt = EncodingUtils.signJwsRSASha512((Key)priv, (byte[])claims.toJson().getBytes(StandardCharsets.UTF_8), Map.of());
        UsernamePasswordCredentials credentials = this.getCredentials(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", new String(jwt, StandardCharsets.UTF_8), registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyAction() {
        OidcClientSecretJwtAuthenticator auth = new OidcClientSecretJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String audience = this.casProperties.getServer().getPrefix().concat("/oidc/oidcAccessToken");
        OidcRegisteredService registeredService = OidcClientSecretJwtAuthenticatorTests.getOidcRegisteredService();
        JwtClaims claims = this.getClaims(registeredService.getClientId(), registeredService.getClientId(), registeredService.getClientId(), audience);
        String key = EncodingUtils.generateJsonWebKey((int)512);
        byte[] jwt = EncodingUtils.signJwsHMACSha512((Key)new AesKey(key.getBytes(StandardCharsets.UTF_8)), (byte[])claims.toJson().getBytes(StandardCharsets.UTF_8), Map.of());
        UsernamePasswordCredentials credentials = this.getCredentials(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", new String(jwt, StandardCharsets.UTF_8), registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyDisabledServiceAction() {
        OidcClientSecretJwtAuthenticator auth = new OidcClientSecretJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String audience = this.casProperties.getServer().getPrefix().concat("/oidc/oidcAccessToken");
        OidcRegisteredService registeredService = OidcClientSecretJwtAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        registeredService.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy().setEnabled(false));
        this.servicesManager.save((RegisteredService)registeredService);
        JwtClaims claims = this.getClaims(registeredService.getClientId(), registeredService.getClientId(), registeredService.getClientId(), audience);
        String key = EncodingUtils.generateJsonWebKey((int)512);
        byte[] jwt = EncodingUtils.signJwsHMACSha512((Key)new AesKey(key.getBytes(StandardCharsets.UTF_8)), (byte[])claims.toJson().getBytes(StandardCharsets.UTF_8), Map.of());
        UsernamePasswordCredentials credentials = this.getCredentials(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", new String(jwt, StandardCharsets.UTF_8), registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyNoUserAction() {
        OidcClientSecretJwtAuthenticator auth = new OidcClientSecretJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService registeredService = OidcClientSecretJwtAuthenticatorTests.getOidcRegisteredService();
        UsernamePasswordCredentials credentials = this.getCredentials(request, "unknown", "----", registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyBadJwt() {
        OidcClientSecretJwtAuthenticator auth = new OidcClientSecretJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService registeredService = OidcClientSecretJwtAuthenticatorTests.getOidcRegisteredService();
        UsernamePasswordCredentials credentials = this.getCredentials(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", "----", registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    private UsernamePasswordCredentials getCredentials(MockHttpServletRequest request, String uid, String password, String clientId) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(uid, password);
        OAuth20Code code = this.defaultOAuthCodeFactory.create((Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "", "", clientId, new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        request.addParameter("code", code.getId());
        return credentials;
    }
}

