/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.authn.OidcPrivateKeyJwtAuthenticator;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.util.EncodingUtils;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oauth.code.time-to-kill-in-seconds=60"})
public class OidcPrivateKeyJwtAuthenticatorTests
extends AbstractOidcTests {
    @Test
    public void verifyAction() throws Exception {
        OidcPrivateKeyJwtAuthenticator auth = new OidcPrivateKeyJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String audience = this.casProperties.getServer().getPrefix().concat("/oidc/oidcAccessToken");
        OidcRegisteredService registeredService = OidcPrivateKeyJwtAuthenticatorTests.getOidcRegisteredService();
        JwtClaims claims = this.getClaims(registeredService.getClientId(), registeredService.getClientId(), registeredService.getClientId(), audience);
        PublicJsonWebKey webKey = (PublicJsonWebKey)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)registeredService)).get();
        byte[] jwt = EncodingUtils.signJwsRSASha512((Key)webKey.getPrivateKey(), (byte[])claims.toJson().getBytes(StandardCharsets.UTF_8), Map.of());
        UsernamePasswordCredentials credentials = this.getCredential(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", new String(jwt, StandardCharsets.UTF_8), registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyBadUser() {
        OidcPrivateKeyJwtAuthenticator auth = new OidcPrivateKeyJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService registeredService = OidcPrivateKeyJwtAuthenticatorTests.getOidcRegisteredService();
        UsernamePasswordCredentials credentials = this.getCredential(request, "unknown", "unknown", registeredService.getClientId());
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    public void verifyBadCred() {
        OidcPrivateKeyJwtAuthenticator auth = new OidcPrivateKeyJwtAuthenticator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry, this.webApplicationServiceFactory, this.casProperties, (ApplicationContext)this.applicationContext);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("urn:ietf:params:oauth:client-assertion-type:jwt-bearer", null);
        auth.validate((Credentials)credentials, (WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    private UsernamePasswordCredentials getCredential(MockHttpServletRequest request, String uid, String password, String clientId) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(uid, password);
        OAuth20Code code = this.defaultOAuthCodeFactory.create((Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "", "", clientId, new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        request.addParameter("code", code.getId());
        return credentials;
    }
}

