/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.oidc.discovery.claims=sub,name,given_name,family_name,middle_name,preferred_username,email,mail,groups"})
@Tag(value="OIDC")
public class OidcCustomScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcCustomScopeAttributeReleasePolicy policy = new OidcCustomScopeAttributeReleasePolicy("groups", CollectionUtils.wrap((Object)"groups"));
        Assertions.assertEquals((Object)"custom", (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"groups", List.of("admin", "user")));
        Map attrs = policy.getAttributes(principal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Principal principal2 = CoreAuthenticationTestUtils.getPrincipal((Map)attrs);
        Map releaseAttrs = policy.getAttributes(principal2, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(releaseAttrs::containsKey));
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().containsAll(policy.determineRequestedAttributeDefinitions(principal2, CoreAuthenticationTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService())));
        Assertions.assertEquals(releaseAttrs.get("groups"), List.of("admin", "user"));
    }

    @Test
    public void verifySerialization() {
        OidcCustomScopeAttributeReleasePolicy policy = new OidcCustomScopeAttributeReleasePolicy("groups", CollectionUtils.wrap((Object)"groups"));
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicy((RegisteredServiceAttributeReleasePolicy)policy);
        OidcRegisteredService service = OidcCustomScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

