/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.core.claims-map.email=mail", "cas.authn.oidc.core.claims-map.email_verified=mail_confirmed"})
public class OidcEmailScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", List.of("cas@example.org"), (String)"email_verified", List.of("cas@example.org")));
        Map attrs = policy.getAttributes(principal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(principal, CoreAuthenticationTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()).containsAll(policy.getAllowedAttributes()));
    }

    @Test
    public void verifyClaimMapOperation() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"mail", List.of("cas@example.org"), (String)"mail_confirmed", List.of("cas@example.org"), (String)"phone", List.of("0000000000")));
        Map attrs = policy.getAttributes(principal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertEquals(List.of("cas@example.org"), attrs.get("email"));
        Assertions.assertEquals(List.of("cas@example.org"), attrs.get("email_verified"));
        Assertions.assertFalse((boolean)attrs.containsKey("phone"));
        Principal serviceTicketPrincipal = CoreAuthenticationTestUtils.getPrincipal((Map)attrs);
        Map releaseAttrs = policy.getAttributes(serviceTicketPrincipal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertEquals(List.of("cas@example.org"), releaseAttrs.get("email"));
        Assertions.assertEquals(List.of("cas@example.org"), releaseAttrs.get("email_verified"));
        Assertions.assertFalse((boolean)releaseAttrs.containsKey("phone"));
    }

    @Test
    public void verifySerialization() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicy((RegisteredServiceAttributeReleasePolicy)policy);
        OidcRegisteredService service = OidcEmailScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

