/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcOpenIdScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcOpenIdScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcOpenIdScopeAttributeReleasePolicy policy = new OidcOpenIdScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.OPENID.getScope(), (Object)policy.getScopeType());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().isEmpty());
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(CoreAuthenticationTestUtils.getPrincipal(), CoreAuthenticationTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()).isEmpty());
    }

    @Test
    public void verifySerialization() {
        OidcOpenIdScopeAttributeReleasePolicy policy = new OidcOpenIdScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicy((RegisteredServiceAttributeReleasePolicy)policy);
        OidcRegisteredService service = OidcOpenIdScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

