/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcPhoneScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.PHONE.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"phone_number_verified", List.of("12134321245"), (String)"phone_number", List.of("12134321245")));
        Map attrs = policy.getAttributes(principal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(principal, CoreAuthenticationTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()).containsAll(policy.getAllowedAttributes()));
    }

    @Test
    public void verifySerialization() {
        OidcPhoneScopeAttributeReleasePolicy policy = new OidcPhoneScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicy((RegisteredServiceAttributeReleasePolicy)policy);
        OidcRegisteredService service = OidcPhoneScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer();
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

