/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims.mapping;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.oidc.core.claims-map.email=mail", "cas.authn.oidc.core.claims-map.email_verified=mail_confirmed"})
@Tag(value="OIDC")
public class OidcDefaultAttributeToScopeClaimMapperTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcDefaultAttributeToScopeClaimMapper mapper = new OidcDefaultAttributeToScopeClaimMapper(CollectionUtils.wrap((String)"name", (Object)"givenName"));
        Assertions.assertTrue((boolean)mapper.containsMappedAttribute("name"));
        Assertions.assertEquals((Object)"givenName", (Object)mapper.getMappedAttribute("name"));
    }

    @Test
    public void verifyClaimMapOperation() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"mail", List.of("cas@example.org"), (String)"mail_confirmed", List.of("cas@example.org")));
        Map attrs = policy.getAttributes(principal, CoreAuthenticationTestUtils.getService(), CoreAuthenticationTestUtils.getRegisteredService());
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(principal, CoreAuthenticationTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()).containsAll(policy.getAllowedAttributes()));
    }
}

