/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Tag(value="OIDC")
@Import(value={OidcAuthenticationContextTestConfiguration.class})
public class OidcServerDiscoverySettingsFactoryTests
extends AbstractOidcTests {
    @Test
    public void verifyAction() {
        Assertions.assertTrue((boolean)this.oidcServerDiscoverySettings.isRequestParameterSupported());
        Assertions.assertTrue((boolean)this.oidcServerDiscoverySettings.isClaimsParameterSupported());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getClaimsSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getClaimTypesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getGrantTypesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getIntrospectionSupportedAuthenticationMethods().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getIdTokenSigningAlgValuesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getSubjectTypesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getAcrValuesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getResponseTypesSupported().isEmpty());
        Assertions.assertFalse((boolean)this.oidcServerDiscoverySettings.getScopesSupported().isEmpty());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getEndSessionEndpoint());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getIntrospectionEndpoint());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getRegistrationEndpoint());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getTokenEndpoint());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getUserinfoEndpoint());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getIssuer());
        Assertions.assertNotNull((Object)this.oidcServerDiscoverySettings.getJwksUri());
    }

    @TestConfiguration(value="OidcAuthenticationContextTestConfiguration")
    public static class OidcAuthenticationContextTestConfiguration {
        @Bean
        public MultifactorAuthenticationProvider dummyProvider() {
            return new TestMultifactorAuthenticationProvider();
        }
    }
}

