/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.dynareg;

import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientRegistrationUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcClientRegistrationResponseTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcRegisteredService service = OidcClientRegistrationResponseTests.getOidcRegisteredService();
        PublicJsonWebKey key = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"rsa", (int)2048);
        service.setJwks(new JsonWebKeySet(new JsonWebKey[]{key}).toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY));
        OidcClientRegistrationResponse input = OidcClientRegistrationUtils.getClientRegistrationResponse((OidcRegisteredService)service, (String)"https://example.com/cas");
        Assertions.assertNotNull((Object)input.getGrantTypes());
        Assertions.assertNotNull((Object)input.getResponseTypes());
        Assertions.assertNotNull((Object)input.getRedirectUris());
        Assertions.assertNotNull((Object)input.getContacts());
    }
}

