/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.issuer;

import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcDefaultIssuerServiceTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        Assertions.assertNotNull((Object)this.oidcIssuerService.determineIssuer(Optional.empty()));
    }

    @Test
    public void verifyServiceIssuer() {
        OidcRegisteredService svc = OidcDefaultIssuerServiceTests.getOidcRegisteredService();
        String issuer = this.oidcIssuerService.determineIssuer(Optional.of(svc));
        Assertions.assertEquals((Object)issuer, (Object)this.casProperties.getAuthn().getOidc().getCore().getIssuer());
        svc.setIdTokenIssuer("https://custom.issuer/");
        issuer = this.oidcIssuerService.determineIssuer(Optional.of(svc));
        Assertions.assertEquals((Object)issuer, (Object)"https://custom.issuer");
    }
}

