/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcDefaultJsonWebKeystoreCacheLoader;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.ResourceUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.jwks.jwks-type=ec", "cas.authn.oidc.jwks.jwks-key-size=384", "cas.authn.oidc.jwks.jwks-file=file:${#systemProperties['java.io.tmpdir']}/keystore.jwks"})
public class OidcDefaultJsonWebKeystoreCacheLoaderTests
extends AbstractOidcTests {
    @BeforeAll
    public static void setup() {
        File file = new File(FileUtils.getTempDirectory(), "keystore.jwks");
        file.delete();
    }

    @Test
    public void verifyNoWebKeys() {
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
        OidcDefaultJsonWebKeystoreCacheLoader loader = (OidcDefaultJsonWebKeystoreCacheLoader)Mockito.mock(OidcDefaultJsonWebKeystoreCacheLoader.class);
        Mockito.when((Object)loader.buildJsonWebKeySet()).thenReturn(Optional.of(jwks));
        Mockito.when((Object)loader.load(Mockito.anyString())).thenCallRealMethod();
        Assertions.assertTrue((boolean)loader.load(UUID.randomUUID().toString()).isEmpty());
        jwks.getJsonWebKeys().add((JsonWebKey)Mockito.mock(JsonWebKey.class));
        Mockito.when((Object)loader.getJsonSigningWebKeyFromJwks((JsonWebKeySet)Mockito.any())).thenReturn(null);
        Assertions.assertTrue((boolean)loader.load(UUID.randomUUID().toString()).isEmpty());
    }

    @Test
    public void verifyBadKeyCount() throws Exception {
        JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
        PublicJsonWebKey jsonWebKey = (PublicJsonWebKey)Mockito.mock(PublicJsonWebKey.class);
        jwks.getJsonWebKeys().add(jsonWebKey);
        OidcDefaultJsonWebKeystoreCacheLoader loader = (OidcDefaultJsonWebKeystoreCacheLoader)Mockito.mock(OidcDefaultJsonWebKeystoreCacheLoader.class);
        Mockito.when((Object)loader.buildJsonWebKeySet()).thenCallRealMethod();
        Mockito.when((Object)loader.load(Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)loader.generateJwksResource()).thenReturn((Object)new ByteArrayResource("jwks".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)loader.buildJsonWebKeySet((Resource)Mockito.any(Resource.class))).thenReturn((Object)jwks);
        Assertions.assertTrue((boolean)loader.load(UUID.randomUUID().toString()).isEmpty());
        Mockito.when((Object)jsonWebKey.getAlgorithm()).thenReturn((Object)"some-alg");
        Mockito.when((Object)loader.getJsonSigningWebKeyFromJwks((JsonWebKeySet)Mockito.any())).thenReturn((Object)jsonWebKey);
        Assertions.assertTrue((boolean)loader.load(UUID.randomUUID().toString()).isEmpty());
    }

    @Test
    public void verifyOperation() {
        Optional publicJsonWebKey1 = (Optional)this.oidcDefaultJsonWebKeystoreCache.get((Object)"https://sso.example.org/cas/oidc");
        Assertions.assertNotNull((Object)publicJsonWebKey1);
        Assertions.assertTrue((boolean)publicJsonWebKey1.isPresent());
        Optional publicJsonWebKey2 = (Optional)this.oidcDefaultJsonWebKeystoreCache.get((Object)"https://sso.example.org/cas/oidc");
        Assertions.assertNotNull((Object)publicJsonWebKey2);
        Assertions.assertTrue((boolean)publicJsonWebKey2.isPresent());
    }

    @Test
    public void verifyNullResource() {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        Mockito.when((Object)gen.generate()).thenReturn(null);
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load("https://cas.example.org").isEmpty());
    }

    @Test
    public void verifyEmptyFile() throws Exception {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        Mockito.when((Object)gen.generate()).thenReturn((Object)ResourceUtils.EMPTY_RESOURCE);
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load("https://cas.example.org").isEmpty());
        File file = File.createTempFile("keys", ".json");
        FileUtils.writeStringToFile((File)file, (String)new JsonWebKeySet(List.of()).toJson(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)gen.generate()).thenReturn((Object)new FileSystemResource(file));
        Assertions.assertTrue((boolean)loader.load("https://cas.example.org").isEmpty());
    }

    @Test
    public void verifyBadKeys() {
        OidcJsonWebKeystoreGeneratorService gen = (OidcJsonWebKeystoreGeneratorService)Mockito.mock(OidcJsonWebKeystoreGeneratorService.class);
        String keys = "{ \"keys\": [ {\"kty\":\"EC\",\"x\":\"sPlKwAgSxxOE\",\"y\":\"6AyisnUKM9H8\",\"crv\":\"P-256\"} ]}";
        Mockito.when((Object)gen.generate()).thenReturn((Object)new ByteArrayResource("{ \"keys\": [ {\"kty\":\"EC\",\"x\":\"sPlKwAgSxxOE\",\"y\":\"6AyisnUKM9H8\",\"crv\":\"P-256\"} ]}".getBytes(StandardCharsets.UTF_8)));
        OidcDefaultJsonWebKeystoreCacheLoader loader = new OidcDefaultJsonWebKeystoreCacheLoader(gen);
        Assertions.assertTrue((boolean)loader.load("https://cas.example.org").isEmpty());
    }
}

