/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.util.List;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ResourceLoader;

@Tag(value="OIDC")
public class OidcJsonWebKeyStoreUtilsTests
extends AbstractOidcTests {
    @Test
    public void verifyKeySet() {
        OidcRegisteredService service = OidcJsonWebKeyStoreUtilsTests.getOidcRegisteredService();
        service.setJwks("");
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet((OidcRegisteredService)service, (ResourceLoader)this.resourceLoader).isEmpty());
    }

    @Test
    public void verifyBadSvc() {
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet(null, (ResourceLoader)this.resourceLoader).isEmpty());
    }

    @Test
    public void verifyEmptyKeySet() {
        OidcRegisteredService service = OidcJsonWebKeyStoreUtilsTests.getOidcRegisteredService();
        service.setJwks(new JsonWebKeySet(List.of()).toJson());
        Assertions.assertTrue((boolean)OidcJsonWebKeyStoreUtils.getJsonWebKeySet((OidcRegisteredService)service, (ResourceLoader)this.resourceLoader).isEmpty());
    }

    @Test
    public void verifyEc() {
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)512));
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)256));
    }

    @Test
    public void verifyParsing() {
        PublicJsonWebKey key = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)"ec", (int)512);
        JsonWebKeySet keyset = new JsonWebKeySet(new JsonWebKey[]{key});
        Assertions.assertNotNull((Object)OidcJsonWebKeyStoreUtils.parseJsonWebKeySet((String)keyset.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)));
    }
}

