/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        OidcRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOidcRegisteredService();
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isPresent());
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isPresent());
    }

    @Test
    public void verifyOperationWithOAuth() {
        OAuthRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOAuthRegisteredService("clientid", "secret");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isEmpty());
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isEmpty());
    }

    @Test
    public void verifyOperationWithKidPerService() {
        OidcRegisteredService service = OidcRegisteredServiceJsonWebKeystoreCacheLoaderTests.getOidcRegisteredService();
        service.setJwksKeyId("myCustomKey");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isEmpty());
        service.setJwksKeyId("1234567890");
        Assertions.assertTrue((boolean)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)service)).isPresent());
    }
}

