/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.generator.OidcDefaultJsonWebKeystoreGeneratorService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.jwks.jwks-file=file:${#systemProperties['java.io.tmpdir']}/something.jwks"})
public class OidcDefaultJsonWebKeystoreGeneratorServiceTests
extends AbstractOidcTests {
    private static File KEYSTORE;

    @BeforeAll
    public static void setup() {
        KEYSTORE = new File(FileUtils.getTempDirectoryPath(), "something.jwks");
        if (KEYSTORE.exists()) {
            Assertions.assertTrue((boolean)KEYSTORE.delete());
        }
    }

    @Test
    public void verifyOperation() {
        Resource resource = this.oidcJsonWebKeystoreGeneratorService.generate();
        Assertions.assertTrue((boolean)resource.exists());
    }

    @Test
    public void verifyCurve256() {
        OidcProperties properties = new OidcProperties();
        properties.getJwks().setJwksType("ec");
        properties.getJwks().setJwksKeySize(256);
        OidcDefaultJsonWebKeystoreGeneratorService service = new OidcDefaultJsonWebKeystoreGeneratorService(properties);
        service.generate((Resource)new FileSystemResource(KEYSTORE));
        Assertions.assertTrue((boolean)KEYSTORE.exists());
    }

    @Test
    public void verifyCurve384() {
        OidcProperties properties = new OidcProperties();
        properties.getJwks().setJwksType("ec");
        properties.getJwks().setJwksKeySize(384);
        OidcDefaultJsonWebKeystoreGeneratorService service = new OidcDefaultJsonWebKeystoreGeneratorService(properties);
        service.generate((Resource)new FileSystemResource(KEYSTORE));
        Assertions.assertTrue((boolean)KEYSTORE.exists());
    }

    @Test
    public void verifyCurve521() {
        OidcProperties properties = new OidcProperties();
        properties.getJwks().setJwksType("ec");
        properties.getJwks().setJwksKeySize(521);
        OidcDefaultJsonWebKeystoreGeneratorService service = new OidcDefaultJsonWebKeystoreGeneratorService(properties);
        service.generate((Resource)new FileSystemResource(KEYSTORE));
        Assertions.assertTrue((boolean)KEYSTORE.exists());
    }
}

