/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcProfileScopeToAttributesFilterTests
extends AbstractOidcTests {
    @Test
    public void verifyOAuth() {
        OAuthRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOAuthRegisteredService("example", "https://example.org");
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal();
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertEquals((Object)original, (Object)principal);
    }

    @Test
    public void verifyOperationFilterWithoutOpenId() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal();
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertEquals((Object)original, (Object)principal);
    }

    @Test
    public void verifyScopeFreeWithOpenIdScope() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object)OidcConstants.StandardScopes.OPENID.getScope()));
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.OPENID.getScope());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("address"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("phone"));
    }

    @Test
    public void verifyOperationFilterWithOpenId() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().add(OidcConstants.StandardScopes.EMAIL.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.ADDRESS.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.PHONE.getScope());
        service.getScopes().add(OidcConstants.StandardScopes.PROFILE.getScope());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("address"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertEquals((int)4, (int)principal.getAttributes().size());
    }

    @Test
    public void verifyOperationFilterWithServiceDefinedScopes() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.EMAIL.getScope());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
        Assertions.assertEquals((int)1, (int)principal.getAttributes().size());
    }

    @Test
    public void verifyOperationFilterWithServiceDefinedReleasePolicy() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PHONE.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.ADDRESS.getScope(), OidcConstants.StandardScopes.EMAIL.getScope()}));
        service.getScopes().clear();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertEquals((int)2, (int)principal.getAttributes().size());
    }

    @Test
    public void verifyByUserInfoClaims() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getClaims()).thenReturn(Map.of("userinfo", Map.of("name", "{\"essential\": true}", "gender", "{\"essential\": true}")));
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn((Object)CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.OPENID.getScope()}));
        service.getScopes().clear();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertEquals((int)2, (int)principal.getAttributes().size());
    }

    @Test
    public void verifyAccessTokenNoScopes() {
        OidcRegisteredService service = OidcProfileScopeToAttributesFilterTests.getOidcRegisteredService();
        OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
        Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)new MockTicketGrantingTicket("casuser"));
        Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope()));
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new OidcProfileScopeAttributeReleasePolicy());
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Principal original = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", (Object)"casuser@example.org", (String)"address", (Object)"1234 Main Street", (String)"phone", (Object)"123445677", (String)"name", (Object)"CAS", (String)"gender", (Object)"male"));
        Principal principal = this.profileScopeToAttributesFilter.filter(CoreAuthenticationTestUtils.getService(), original, (RegisteredService)service, (WebContext)context, accessToken);
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("name"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("gender"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("address"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("phone"));
        Assertions.assertTrue((boolean)principal.getAttributes().containsKey("email"));
    }
}

