/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcUserProfileDataCreatorTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        OAuth20AccessToken accessToken = this.getAccessToken();
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, context);
        Assertions.assertFalse((boolean)data.isEmpty());
        Assertions.assertEquals((long)accessToken.getTicketGrantingTicket().getAuthentication().getAuthenticationDate().toEpochSecond(), (long)((Long)data.get("auth_time")));
        Assertions.assertTrue((boolean)data.containsKey("sub"));
        Assertions.assertTrue((boolean)data.containsKey("id"));
        Assertions.assertTrue((boolean)data.containsKey("client_id"));
        Assertions.assertTrue((boolean)data.containsKey("attributes"));
        Assertions.assertTrue((boolean)data.containsKey("service"));
        Map attrs = (Map)data.get("attributes");
        Assertions.assertTrue((boolean)attrs.containsKey("email"));
    }

    @Test
    public void verifyTokenWithClaims() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        String claims = "\"userinfo\": {\"given_name\": {\"essential\": true}}";
        request.addParameter("claims", "\"userinfo\": {\"given_name\": {\"essential\": true}}");
        Map result = OAuth20Utils.parseRequestClaims((WebContext)context);
        OAuth20AccessToken accessToken = this.getAccessToken();
        Mockito.when((Object)accessToken.getClaims()).thenReturn((Object)result);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, context);
        Assertions.assertFalse((boolean)data.isEmpty());
        Assertions.assertTrue((boolean)data.containsKey("sub"));
    }
}

