/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.user-info-signing-alg-values-supported=RS256", "cas.authn.oidc.discovery.user-info-encryption-alg-values-supported=RSA1_5,RSA-OAEP,RSA-OAEP-256,A128KW,A192KW,A256KW", "cas.authn.oauth.user-profile-view-type=FLAT"})
public class OidcUserProfileViewRendererFlatTests
extends AbstractOidcTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken();
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getBody());
        Map result = (Map)MAPPER.readValue(entity.getBody().toString(), Map.class);
        Assertions.assertTrue((boolean)result.containsKey("auth_time"));
        Assertions.assertTrue((boolean)result.containsKey("sub"));
        Assertions.assertTrue((boolean)result.containsKey("id"));
        Assertions.assertTrue((boolean)result.containsKey("client_id"));
        Assertions.assertTrue((boolean)result.containsKey("service"));
        Assertions.assertTrue((boolean)result.containsKey("email"));
        Assertions.assertEquals((Object)"casuser@example.org", result.get("email"));
    }

    @Test
    public void verifyFailsOperation() throws Exception {
        String id = UUID.randomUUID().toString();
        OidcRegisteredService service = OidcUserProfileViewRendererFlatTests.getOidcRegisteredService(id);
        service.setUserInfoSigningAlg("none");
        service.setUserInfoEncryptedResponseAlg("none");
        this.servicesManager.save((RegisteredService)service);
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        OAuth20AccessToken accessToken = this.getAccessToken(id);
        Map data = this.oidcUserProfileDataCreator.createFrom(accessToken, context);
        ResponseEntity entity = this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)entity.getStatusCode());
        service.setUserInfoSigningAlg("RS256");
        service.setUserInfoEncryptedResponseAlg("none");
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertEquals((Object)HttpStatus.BAD_REQUEST, (Object)this.oidcUserProfileViewRenderer.render(data, accessToken, (HttpServletResponse)response).getStatusCode());
    }
}

