/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.services;

import java.util.Set;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.core.user-defined-scopes.SomeCustomScope=name"})
public class OidcServiceRegistryListenerTests
extends AbstractOidcTests {
    @Test
    public void verifyOperationRecon() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        Set scopes = service.getScopes();
        scopes.add(OidcConstants.StandardScopes.ADDRESS.getScope());
        scopes.add(OidcConstants.StandardScopes.EMAIL.getScope());
        scopes.add(OidcConstants.StandardScopes.OFFLINE_ACCESS.getScope());
        scopes.add(OidcConstants.StandardScopes.OPENID.getScope());
        scopes.add(OidcConstants.StandardScopes.PHONE.getScope());
        scopes.add(OidcConstants.StandardScopes.PROFILE.getScope());
        scopes.add("SomeCustomScope");
        service = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        Assertions.assertTrue((boolean)(policy instanceof ChainingAttributeReleasePolicy));
        ChainingAttributeReleasePolicy chain = (ChainingAttributeReleasePolicy)policy;
        Assertions.assertEquals((int)5, (int)chain.size());
    }

    @Test
    public void verifyScopeFreeAttributeRelease() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        service.getScopes().clear();
        Set scopes = service.getScopes();
        scopes.add(OidcConstants.StandardScopes.OPENID.getScope());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        service = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        Assertions.assertFalse((boolean)(policy instanceof ChainingAttributeReleasePolicy));
        Assertions.assertTrue((boolean)(policy instanceof ReturnAllAttributeReleasePolicy));
    }

    @Test
    public void verifyOperationEmptyScopes() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        service.getScopes().clear();
        OidcRegisteredService processed = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        Assertions.assertEquals((Object)service.getAttributeReleasePolicy(), (Object)processed.getAttributeReleasePolicy());
    }

    @Test
    public void verifyUnknownScope() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        Set scopes = service.getScopes();
        service.getScopes().clear();
        scopes.add("unknown");
        service = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        Assertions.assertTrue((boolean)(policy instanceof DenyAllAttributeReleasePolicy));
    }

    @Test
    public void verifyOperationReconAsChain() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.OPENID.getScope());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(CollectionUtils.wrapList((Object[])new String[]{"cn"})));
        service = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        Assertions.assertFalse((boolean)(policy instanceof ChainingAttributeReleasePolicy));
        Assertions.assertTrue((boolean)(policy instanceof ReturnAllowedAttributeReleasePolicy));
    }

    @Test
    public void verifyReleasePolicyStartingWithChain() {
        OidcRegisteredService service = OidcServiceRegistryListenerTests.getOidcRegisteredService();
        service.getScopes().clear();
        service.getScopes().add(OidcConstants.StandardScopes.OPENID.getScope());
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(CollectionUtils.wrapList((Object[])new String[]{"cn"})));
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        service = (OidcRegisteredService)this.oidcServiceRegistryListener.postLoad((RegisteredService)service);
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        Assertions.assertFalse((boolean)(policy instanceof ChainingAttributeReleasePolicy));
        Assertions.assertTrue((boolean)(policy instanceof ReturnAllowedAttributeReleasePolicy));
    }
}

