/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.logout.DefaultSingleLogoutRequestContext;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.slo.OidcSingleLogoutMessageCreator;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.DigestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="OIDC")
public class OidcSingleLogoutMessageCreatorTests
extends AbstractOidcTests {
    private static final String PRINCIPAL_ID = "jleleu";

    @Test
    public void verifyBackChannelLogout() throws ParseException {
        OidcRegisteredService service = OidcSingleLogoutMessageCreatorTests.getOidcRegisteredService(true, false);
        OidcConfigurationContext context = ((OidcConfigurationContext.OidcConfigurationContextBuilder)((OidcConfigurationContext.OidcConfigurationContextBuilder)OidcConfigurationContext.builder().idTokenSigningAndEncryptionService(this.oidcTokenSigningAndEncryptionService)).casProperties(this.casProperties)).issuerService((OidcIssuerService)new OidcDefaultIssuerService(this.casProperties.getAuthn().getOidc())).build();
        Principal principal = RegisteredServiceTestUtils.getPrincipal((String)PRINCIPAL_ID);
        Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal);
        TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
        Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
        DefaultSingleLogoutRequestContext logoutRequest = DefaultSingleLogoutRequestContext.builder().logoutType(RegisteredServiceLogoutType.BACK_CHANNEL).registeredService((RegisteredService)service).executionRequest(SingleLogoutExecutionRequest.builder().ticketGrantingTicket(tgt).build()).build();
        OidcSingleLogoutMessageCreator creator = new OidcSingleLogoutMessageCreator(context);
        SingleLogoutMessage message = creator.create((SingleLogoutRequestContext)logoutRequest);
        Assertions.assertNull((Object)message.getMessage());
        String token = message.getPayload();
        JWTClaimsSet claims = JWTParser.parse((String)token).getJWTClaimsSet();
        Assertions.assertEquals((Object)"https://sso.example.org/cas/oidc", (Object)claims.getIssuer());
        Assertions.assertEquals((Object)PRINCIPAL_ID, (Object)claims.getSubject());
        Assertions.assertEquals((Object)service.getClientId(), claims.getAudience().get(0));
        Assertions.assertNotNull((Object)claims.getClaim("iat"));
        Assertions.assertNotNull((Object)claims.getClaim("jti"));
        Map events = (Map)claims.getClaim("events");
        Assertions.assertNotNull(events.get("http://schemas.openid.net/event/backchannel-logout"));
        Assertions.assertEquals((Object)DigestUtils.sha((String)"TGT-0"), (Object)claims.getClaim("sid"));
    }

    @Test
    public void verifyFrontChannelLogout() {
        OidcConfigurationContext context = OidcConfigurationContext.builder().build();
        DefaultSingleLogoutRequestContext logoutRequest = DefaultSingleLogoutRequestContext.builder().logoutType(RegisteredServiceLogoutType.FRONT_CHANNEL).build();
        OidcSingleLogoutMessageCreator creator = new OidcSingleLogoutMessageCreator(context);
        SingleLogoutMessage message = creator.create((SingleLogoutRequestContext)logoutRequest);
        Assertions.assertEquals((Object)"", (Object)message.getPayload());
        Assertions.assertNull((Object)message.getMessage());
    }
}

