/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import java.util.Optional;
import java.util.UUID;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="OIDC")
public class OidcSingleLogoutServiceLogoutUrlBuilderTests
extends AbstractOidcTests {
    @Override
    @BeforeEach
    public void initialize() {
        this.servicesManager.deleteAll();
        super.initialize();
    }

    @Test
    public void verifyOperation() {
        String id = UUID.randomUUID().toString();
        this.servicesManager.save((RegisteredService)OidcSingleLogoutServiceLogoutUrlBuilderTests.getOidcRegisteredService(id));
        Assertions.assertTrue((this.singleLogoutServiceLogoutUrlBuilder.getOrder() > 0 ? 1 : 0) != 0);
        MockHttpServletRequest request = new MockHttpServletRequest();
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"https://somewhere.org");
        Assertions.assertFalse((boolean)this.singleLogoutServiceLogoutUrlBuilder.isServiceAuthorized((WebApplicationService)service, Optional.of(request)));
        request.addParameter("client_id", id);
        Assertions.assertTrue((boolean)this.singleLogoutServiceLogoutUrlBuilder.isServiceAuthorized((WebApplicationService)RegisteredServiceTestUtils.getService(), Optional.of(request)));
    }
}

