/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenAtHashGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
public class OidcIdTokenGeneratorServiceTests {
    private static final String OIDC_CLAIM_EMAIL = "email";
    private static final String OIDC_CLAIM_PHONE_NUMBER = "phone_number";
    private static final String OIDC_CLAIM_NAME = "name";

    @Nested
    @TestPropertySource(properties={"cas.authn.oidc.core.include-id-token-claims=false", "cas.authn.oauth.access-token.crypto.encryption-enabled=false", "cas.authn.oidc.core.claims-map.preferred_username=custom-attribute"})
    public class DefaultTests
    extends AbstractOidcTests {
        @Test
        public void verifyTokenGeneration() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            Mockito.when((Object)tgt.getServices()).thenReturn((Object)CollectionUtils.wrap((String)"service", (Object)service));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
            Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)authentication);
            Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
            Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
            Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PHONE.getScope()));
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.ID_TOKEN, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertEquals((long)authentication.getAuthenticationDate().toEpochSecond(), (long)((Long)claims.getClaimValue("auth_time")));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
            Assertions.assertEquals((Object)"casuser@example.org", (Object)claims.getStringClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertEquals((Object)"casuser", (Object)claims.getStringClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertEquals(phoneValues, (Object)claims.getStringListClaimValue(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }

        @Test
        public void verifyTokenGenerationWithoutClaimsForCodeResponseType() {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            Mockito.when((Object)tgt.getServices()).thenReturn((Object)CollectionUtils.wrap((String)"service", (Object)service));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
            Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)authentication);
            Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
            Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
            Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PHONE.getScope()));
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }

        @Test
        public void verifyTokenGenerationWithOutClaimsForAuthzCodeGrantType() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            Mockito.when((Object)tgt.getServices()).thenReturn((Object)CollectionUtils.wrap((String)"service", (Object)service));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
            Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)authentication);
            Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
            Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
            Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PHONE.getScope()));
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.ID_TOKEN, OAuth20GrantTypes.AUTHORIZATION_CODE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertFalse((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }

        @Test
        public void verifyTokenGenerationWithoutCallbackService() {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
            MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
            Mockito.when((Object)tgt.getServices()).thenReturn(new HashMap());
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce"), (String)mfa.getCore().getAuthenticationContextAttribute(), List.of("context-cass"), (String)"successfulAuthenticationHandlers", List.of("Handler1")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
            Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)authentication);
            Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
            Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid"));
            Assertions.assertNotNull((Object)idToken);
        }

        @Test
        public void verifyTokenGenerationFailsWithoutProfile() {
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                MockHttpServletRequest request = new MockHttpServletRequest();
                MockHttpServletResponse response = new MockHttpServletResponse();
                OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
                this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid"));
            });
        }

        @Test
        public void verifyUnknownServiceType() {
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                MockHttpServletRequest request = new MockHttpServletRequest();
                MockHttpServletResponse response = new MockHttpServletResponse();
                OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
                this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)new MockOAuthRegisteredService());
            });
        }

        @RepeatedTest(value=2)
        public void verifyAccessTokenAsJwt(RepetitionInfo repetitionInfo) throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getServices()).thenReturn(new HashMap());
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = this.getAccessToken();
            OidcRegisteredService registeredService = DefaultTests.getOidcRegisteredService(accessToken.getClientId());
            registeredService.setJwtAccessToken(true);
            registeredService.setIdTokenSigningAlg("RS256");
            registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"false"}), RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{repetitionInfo.getCurrentRepetition() % 2 == 0 ? "false" : "true"})));
            this.servicesManager.save((RegisteredService)registeredService);
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.of(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim("at_hash"));
            Assertions.assertTrue((boolean)claims.hasClaim("auth_time"));
            String issuer = this.oidcIssuerService.determineIssuer(Optional.of(registeredService));
            Assertions.assertEquals((Object)issuer, (Object)claims.getIssuer());
            String hash = (String)claims.getClaimValue("at_hash", String.class);
            String encodedAccessToken = OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService((RegisteredService)registeredService).service(accessToken.getService()).casProperties(this.casProperties).accessTokenJwtBuilder(this.oidcAccessTokenJwtBuilder).issuer(issuer).build().encode();
            String newHash = OAuth20AccessTokenAtHashGenerator.builder().encodedAccessToken(encodedAccessToken).registeredService((RegisteredService)registeredService).algorithm(registeredService.getIdTokenSigningAlg()).build().generate();
            Assertions.assertEquals((Object)hash, (Object)newHash);
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption-enabled=false", "cas.authn.oidc.core.include-id-token-claims=true"})
    public class IgnoringResponseTypeTests
    extends AbstractOidcTests {
        @Test
        public void verifyTokenGenerationWithClaimsForCodeResponseType() {
            MockHttpServletRequest request = new MockHttpServletRequest();
            CommonProfile profile = new CommonProfile();
            profile.setClientName("OIDC");
            profile.setId("casuser");
            request.setAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
            MockHttpServletResponse response = new MockHttpServletResponse();
            TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
            Mockito.when((Object)tgt.getId()).thenReturn((Object)"TGT-0");
            String callback = this.casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            WebApplicationService service = new WebApplicationServiceFactory().createService(callback);
            Mockito.when((Object)tgt.getServices()).thenReturn((Object)CollectionUtils.wrap((String)"service", (Object)service));
            List<String> phoneValues = List.of("123456789", "4805553241");
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL, List.of("casuser@example.org"), (String)"color", List.of("yellow"), (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER, phoneValues, (String)OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME, List.of("casuser")));
            Authentication authentication = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, (Map)CollectionUtils.wrap((String)"state", List.of("some-state"), (String)"nonce", List.of("some-nonce")));
            Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)authentication);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)Mockito.mock(OAuth20AccessToken.class);
            Mockito.when((Object)accessToken.getAuthentication()).thenReturn((Object)authentication);
            Mockito.when((Object)accessToken.getTicketGrantingTicket()).thenReturn((Object)tgt);
            Mockito.when((Object)accessToken.getId()).thenReturn((Object)this.getClass().getSimpleName());
            Mockito.when((Object)accessToken.getScopes()).thenReturn(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PHONE.getScope()));
            OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)"clientid");
            registeredService.setScopes(CollectionUtils.wrapSet((Object[])new String[]{OidcConstants.StandardScopes.EMAIL.getScope(), OidcConstants.StandardScopes.PROFILE.getScope(), OidcConstants.StandardScopes.PHONE.getScope()}));
            String idToken = this.oidcIdTokenGenerator.generate((WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response), accessToken, 30L, OAuth20ResponseTypes.CODE, OAuth20GrantTypes.NONE, (OAuthRegisteredService)registeredService);
            Assertions.assertNotNull((Object)idToken);
            JwtClaims claims = this.oidcTokenSigningAndEncryptionService.decode(idToken, Optional.ofNullable(registeredService));
            Assertions.assertNotNull((Object)claims);
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_EMAIL));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_NAME));
            Assertions.assertTrue((boolean)claims.hasClaim(OidcIdTokenGeneratorServiceTests.OIDC_CLAIM_PHONE_NUMBER));
        }
    }

    private static class MockOAuthRegisteredService
    extends OAuthRegisteredService {
        private static final long serialVersionUID = 8152953800891665827L;

        private MockOAuthRegisteredService() {
        }
    }
}

