/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcDefaultIssuerService;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.token.OidcIdTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.id-token-signing-alg-values-supported=RS256,RS384,RS512", "cas.authn.oidc.discovery.id-token-encryption-encoding-values-supported=A128CBC-HS256,A192CBC-HS384,A256CBC-HS512,A128GCM,A192GCM,A256GCM"})
public class OidcIdTokenSigningAndEncryptionServiceTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        JwtClaims claims = this.getClaims();
        String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(), claims);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void verifyWrongType() {
        Assertions.assertFalse((boolean)this.oidcTokenSigningAndEncryptionService.shouldEncryptToken(OidcIdTokenSigningAndEncryptionServiceTests.getOAuthRegisteredService("1", "http://localhost/cas")));
        Assertions.assertFalse((boolean)this.oidcTokenSigningAndEncryptionService.shouldSignToken(OidcIdTokenSigningAndEncryptionServiceTests.getOAuthRegisteredService("1", "http://localhost/cas")));
    }

    @Test
    public void verifySkipSigning() {
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(false, false);
        boolean result = this.oidcTokenSigningAndEncryptionService.shouldSignToken((OAuthRegisteredService)oidcRegisteredService);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void verifyValidationOperation() {
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(true, false);
        String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        JwtClaims jwt = this.oidcTokenSigningAndEncryptionService.decode(result, Optional.of(oidcRegisteredService));
        Assertions.assertNotNull((Object)jwt);
    }

    @Test
    public void verifyDecodingFailureBadToken() {
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(true, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode("bad-token", Optional.of(oidcRegisteredService)));
    }

    @Test
    public void verifyDecodingFailureNoIssuer() {
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(true, false);
        JwtClaims claims = this.getClaims();
        claims.setIssuer("");
        String result = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result, Optional.of(oidcRegisteredService)));
    }

    @Test
    public void verifyDecodingFailureBadIssuer() {
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(true, false);
        JwtClaims claims = this.getClaims();
        claims.setIssuer("bad-issuer");
        String result2 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result2, Optional.of(oidcRegisteredService)));
    }

    @Test
    public void verifyDecodingFailureBadClient() {
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService(true, false);
        JwtClaims claims = this.getClaims();
        claims.setStringClaim("client_id", "");
        String result3 = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.decode(result3, Optional.of(oidcRegisteredService)));
    }

    @Test
    public void verifyNoneNotSupported() {
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService();
        oidcRegisteredService.setIdTokenSigningAlg("none");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims));
        oidcRegisteredService.setIdTokenSigningAlg("RS256");
        oidcRegisteredService.setIdTokenEncryptionAlg("none");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims));
    }

    @Test
    public void verifyNoneSupported() {
        OidcServerDiscoverySettings discovery = new OidcServerDiscoverySettings(this.casProperties.getAuthn().getOidc().getCore().getIssuer());
        discovery.setIdTokenSigningAlgValuesSupported(List.of("none"));
        discovery.setIdTokenEncryptionAlgValuesSupported(List.of("none"));
        OidcIdTokenSigningAndEncryptionService service = new OidcIdTokenSigningAndEncryptionService(this.oidcDefaultJsonWebKeystoreCache, this.oidcServiceJsonWebKeystoreCache, (OidcIssuerService)new OidcDefaultIssuerService(this.casProperties.getAuthn().getOidc()), discovery);
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcIdTokenSigningAndEncryptionServiceTests.getOidcRegisteredService();
        oidcRegisteredService.setIdTokenSigningAlg("none");
        oidcRegisteredService.setIdTokenEncryptionAlg("none");
        String result = service.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        Assertions.assertNotNull((Object)result);
    }
}

