/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.Map;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oauth.access-token.crypto.encryption-enabled=false"})
public class OidcJwtAccessTokenEncoderTests
extends AbstractOidcTests {
    private OAuth20JwtAccessTokenEncoder getAccessTokenEncoder(OAuth20AccessToken accessToken, RegisteredService registeredService) {
        return OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken).registeredService(registeredService).service(accessToken.getService()).accessTokenJwtBuilder(this.oidcAccessTokenJwtBuilder).casProperties(this.casProperties).build();
    }

    @Test
    public void verifyEncodingWithoutEncryptionForService() {
        OAuth20AccessToken accessToken = this.getAccessToken();
        OidcRegisteredService registeredService = OidcJwtAccessTokenEncoderTests.getOidcRegisteredService(accessToken.getClientId());
        registeredService.setJwtAccessToken(true);
        registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"false"})));
        this.servicesManager.save((RegisteredService)registeredService);
        String token1 = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService).encode();
        String token2 = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService).encode();
        Assertions.assertEquals((Object)token1, (Object)token2);
    }

    @Test
    public void verifyExtractionAsParameterForService() {
        OAuth20AccessToken accessToken = this.getAccessToken();
        OidcRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService);
        String encodedAccessToken = encoder.encode();
        String decoded = encoder.decode(encodedAccessToken);
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded);
    }

    @Test
    public void verifyEncodingWithNoCiphersForService() {
        OAuth20AccessToken accessToken = this.getAccessToken("", "encoding-service-clientid");
        OidcRegisteredService registeredService = this.getRegisteredServiceForJwtAccessTokenWithKeys(accessToken);
        OAuth20JwtAccessTokenEncoder encoder = this.getAccessTokenEncoder(accessToken, (RegisteredService)registeredService);
        String token1 = encoder.encode();
        String token2 = encoder.encode();
        Assertions.assertEquals((Object)token1, (Object)token2);
        String decoded1 = encoder.decode(token1);
        String decoded2 = encoder.decode(token2);
        Assertions.assertEquals((Object)decoded1, (Object)decoded2);
        Assertions.assertEquals((Object)accessToken.getId(), (Object)decoded1);
    }

    private OidcRegisteredService getRegisteredServiceForJwtAccessTokenWithKeys(OAuth20AccessToken accessToken) {
        OidcRegisteredService registeredService = OidcJwtAccessTokenEncoderTests.getOidcRegisteredService(accessToken.getClientId());
        registeredService.setJwtAccessToken(true);
        DefaultRegisteredServiceProperty property = new DefaultRegisteredServiceProperty(new String[]{"false"});
        registeredService.setProperties(Map.of(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), property, RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), property));
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }
}

