/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.SignedJWT;
import java.util.Optional;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.EncodingUtils;
import org.jose4j.jwk.JsonWebKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="OIDC")
public class OidcRegisteredServiceJwtAccessTokenCipherExecutorTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() throws Exception {
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorTests.getOidcRegisteredService("whatever");
        Assertions.assertTrue((boolean)this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.supports((RegisteredService)service));
        OAuth20AccessToken at = this.getAccessToken();
        String encoded = this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.encode(at.getId(), Optional.of(service));
        Assertions.assertNotNull((Object)encoded);
        JWSHeader header = SignedJWT.parse((String)encoded).getHeader();
        Assertions.assertNotNull((Object)header.getAlgorithm());
        String decoded = this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.decode(encoded, Optional.of(service));
        Assertions.assertNotNull((Object)decoded);
        Assertions.assertEquals((Object)at.getId(), (Object)decoded);
    }

    @Test
    public void verifyNoSigningKey() {
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorTests.getOidcRegisteredService("whatever");
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED.getDefaultValue()}));
        String key = EncodingUtils.generateJsonWebKey((int)512);
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_KEY.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{key}));
        OAuth20AccessToken at = this.getAccessToken();
        String encoded = this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.encode(at.getId(), Optional.of(service));
        Assertions.assertNotNull((Object)encoded);
    }

    @Test
    public void verifyEncKey() {
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorTests.getOidcRegisteredService("whatever");
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"true"}));
        JsonWebKey key = EncodingUtils.newJsonWebKey((int)2048);
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{key.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)}));
        OAuth20AccessToken at = this.getAccessToken();
        String encoded = this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.encode(at.getId(), Optional.of(service));
        Assertions.assertNotNull((Object)encoded);
    }

    @Test
    public void verifyNoEncKey() {
        OidcRegisteredService service = OidcRegisteredServiceJwtAccessTokenCipherExecutorTests.getOidcRegisteredService("whatever");
        service.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED.getPropertyName(), new DefaultRegisteredServiceProperty(new String[]{"true"}));
        OAuth20AccessToken at = this.getAccessToken();
        String encoded = this.oidcRegisteredServiceJwtAccessTokenCipherExecutor.encode(at.getId(), Optional.of(service));
        Assertions.assertNotNull((Object)encoded);
    }
}

