/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcRequestSupportTests {
    protected static JEEContext getContextForEndpoint(String endpoint) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("sso.example.org");
        request.setServerPort(8443);
        request.setRequestURI("/cas/oidc/" + endpoint);
        MockHttpServletResponse response = new MockHttpServletResponse();
        return new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Test
    public void verifyRemovePrompt() {
        String url = "https://tralala.whapi.com/something?prompt=consent";
        String request = OidcRequestSupport.removeOidcPromptFromAuthorizationRequest((String)"https://tralala.whapi.com/something?prompt=consent", (String)"consent");
        Assertions.assertFalse((boolean)request.contains("prompt"));
    }

    @Test
    public void verifyOidcPrompt() {
        String url = "https://tralala.whapi.com/something?prompt=value1";
        Set authorizationRequest = OidcRequestSupport.getOidcPromptFromAuthorizationRequest((String)"https://tralala.whapi.com/something?prompt=value1");
        Assertions.assertEquals((Object)"value1", (Object)authorizationRequest.toArray()[0]);
    }

    @Test
    public void verifyOidcPromptFromContext() {
        String url = "https://tralala.whapi.com/something?prompt=value1";
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?prompt=value1");
        Set authorizationRequest = OidcRequestSupport.getOidcPromptFromAuthorizationRequest((WebContext)context);
        Assertions.assertEquals((Object)"value1", (Object)authorizationRequest.toArray()[0]);
    }

    @Test
    public void verifyOidcMaxAgeTooOld() {
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=1");
        ZonedDateTime authenticationDate = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(5L);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (ZonedDateTime)authenticationDate));
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (ZonedDateTime)authenticationDate);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (Authentication)authn));
        CommonProfile profile = new CommonProfile();
        profile.setClientName("OIDC");
        profile.setId("casuser");
        profile.addAuthenticationAttribute("authenticationDate", (Object)authenticationDate);
        Assertions.assertTrue((boolean)OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context, (BasicUserProfile)profile));
    }

    @Test
    public void verifyOidcMaxAgeTooOldForContext() {
        ZonedDateTime authenticationDate = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(5L);
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((String)"casuser", (ZonedDateTime)authenticationDate);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://tralala.whapi.com/something?max_age=1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        CasCookieBuilder builder = (CasCookieBuilder)Mockito.mock(CasCookieBuilder.class);
        Mockito.when((Object)builder.retrieveCookieValue((HttpServletRequest)Mockito.any())).thenReturn((Object)UUID.randomUUID().toString());
        TicketRegistrySupport registrySupport = (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class);
        Mockito.when((Object)registrySupport.getAuthenticationFrom(Mockito.anyString())).thenReturn((Object)authn);
        OidcRequestSupport support = new OidcRequestSupport(builder, registrySupport, (OidcIssuerService)Mockito.mock(OidcIssuerService.class));
        Assertions.assertTrue((boolean)support.isCasAuthenticationOldForMaxAgeAuthorizationRequest((WebContext)context));
    }

    @Test
    public void verifyOidcMaxAge() {
        WebContext context = (WebContext)Mockito.mock(WebContext.class);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=1000");
        Optional age = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertTrue((boolean)age.isPresent());
        Assertions.assertEquals((long)((Long)age.get()), (long)1000L);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?max_age=NA");
        Optional age2 = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertTrue((boolean)age2.isPresent());
        Assertions.assertEquals((long)((Long)age2.get()), (long)-1L);
        Mockito.when((Object)context.getFullRequestURL()).thenReturn((Object)"https://tralala.whapi.com/something?");
        Optional age3 = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest((WebContext)context);
        Assertions.assertFalse((boolean)age3.isPresent());
    }

    @Test
    public void verifyAuthnProfile() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://www.example.org");
        request.setQueryString("param=value");
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        CommonProfile profile = new CommonProfile();
        context.setRequestAttribute("pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        Assertions.assertTrue((boolean)OidcRequestSupport.isAuthenticationProfileAvailable((JEEContext)context, (SessionStore)JEESessionStore.INSTANCE).isPresent());
    }

    @Test
    public void verifyGetRedirectUrlWithError() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("example.org");
        request.addParameter("state", "123456");
        request.setServerPort(443);
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        String expectedUrlWithError = context.getRequestURL() + "?error=login_required&state=123456";
        Assertions.assertEquals((Object)expectedUrlWithError, (Object)OidcRequestSupport.getRedirectUrlWithError((String)context.getRequestURL(), (String)"login_required", (WebContext)context));
    }

    @Test
    public void validateStaticIssuer() {
        OidcIssuerService issuerService = (OidcIssuerService)Mockito.mock(OidcIssuerService.class);
        String staticIssuer = "https://sso.example.org:8443/cas/oidc";
        Mockito.when((Object)issuerService.determineIssuer((Optional)Mockito.any())).thenReturn((Object)"https://sso.example.org:8443/cas/oidc");
        OidcRequestSupport support = new OidcRequestSupport((CasCookieBuilder)Mockito.mock(CasCookieBuilder.class), (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class), issuerService);
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("authorize"), "authorize"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("profile"), "profile"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("logout"), "logout"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("realms/authorize"), "authorize"));
    }

    @Test
    public void validateDynamicIssuer() {
        OidcIssuerService issuerService = (OidcIssuerService)Mockito.mock(OidcIssuerService.class);
        String staticIssuer = "https://sso.example.org:8443/cas/oidc/custom/fawnoos/issuer";
        Mockito.when((Object)issuerService.determineIssuer((Optional)Mockito.any())).thenReturn((Object)"https://sso.example.org:8443/cas/oidc/custom/fawnoos/issuer");
        OidcRequestSupport support = new OidcRequestSupport((CasCookieBuilder)Mockito.mock(CasCookieBuilder.class), (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class), issuerService);
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/authorize"), "authorize"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/profile"), "profile"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer/oidcAuthorize"), "oidcAuthorize"));
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("custom/fawnoos/issuer"), "unknown"));
    }

    @Test
    public void validateDynamicIssuerForLogout() {
        OidcIssuerService issuerService = (OidcIssuerService)Mockito.mock(OidcIssuerService.class);
        String staticIssuer = "https://sso.example.org:8443/cas/oidc";
        Mockito.when((Object)issuerService.determineIssuer((Optional)Mockito.any())).thenReturn((Object)"https://sso.example.org:8443/cas/oidc");
        OidcRequestSupport support = new OidcRequestSupport((CasCookieBuilder)Mockito.mock(CasCookieBuilder.class), (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class), issuerService);
        Assertions.assertTrue((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("logout"), "oidcLogout"));
    }

    @Test
    public void validateIssuerMismatch() {
        OidcIssuerService issuerService = (OidcIssuerService)Mockito.mock(OidcIssuerService.class);
        String staticIssuer = "https://sso.example.org:8443/cas/openid-connect";
        Mockito.when((Object)issuerService.determineIssuer((Optional)Mockito.any())).thenReturn((Object)"https://sso.example.org:8443/cas/openid-connect");
        OidcRequestSupport support = new OidcRequestSupport((CasCookieBuilder)Mockito.mock(CasCookieBuilder.class), (TicketRegistrySupport)Mockito.mock(TicketRegistrySupport.class), issuerService);
        Assertions.assertFalse((boolean)support.isValidIssuerForEndpoint(OidcRequestSupportTests.getContextForEndpoint("logout"), "oidcLogout"));
    }
}

