/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
public class OidcAccessTokenResponseGeneratorTests
extends AbstractOidcTests {
    @Test
    public void verifyAccessTokenResponseAsCode() {
        OAuth20TokenGeneratedResult token = OAuth20TokenGeneratedResult.builder().accessToken(this.getAccessToken()).refreshToken(OidcAccessTokenResponseGeneratorTests.getRefreshToken()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).responseType(OAuth20ResponseTypes.CODE).build();
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().service((Service)RegisteredServiceTestUtils.getService()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).resourceLoader(this.resourceLoader).casProperties(this.casProperties).generatedToken(token).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        ModelAndView mv = this.oidcAccessTokenResponseGenerator.generate((WebContext)context, result);
        Assertions.assertNotNull((Object)mv);
        ModelMap modelMap = mv.getModelMap();
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"access_token"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"scope"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"expires_in"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"token_type"));
    }

    @Test
    public void verifyAccessTokenResponseForDeviceCode() {
        OAuth20DeviceToken devCode = this.deviceTokenFactory.createDeviceCode((Service)RegisteredServiceTestUtils.getService());
        OAuth20TokenGeneratedResult token = OAuth20TokenGeneratedResult.builder().registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).responseType(OAuth20ResponseTypes.DEVICE_CODE).deviceCode(devCode.getId()).userCode(this.deviceUserCodeFactory.createDeviceUserCode(devCode).getId()).build();
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().service((Service)RegisteredServiceTestUtils.getService()).registeredService((RegisteredService)OidcAccessTokenResponseGeneratorTests.getOidcRegisteredService()).resourceLoader(this.resourceLoader).casProperties(this.casProperties).generatedToken(token).responseType(OAuth20ResponseTypes.DEVICE_CODE).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        ModelAndView mv = this.oidcAccessTokenResponseGenerator.generate((WebContext)context, result);
        Assertions.assertNotNull((Object)mv);
        ModelMap modelMap = mv.getModelMap();
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"verification_uri"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"user_code"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"device_code"));
        Assertions.assertTrue((boolean)modelMap.containsKey((Object)"interval"));
    }
}

