/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.discovery.authorization-response-issuer-parameter-supported=true"})
public class OidcAuthorizationModelAndViewBuilderTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauthAuthorizationModelAndViewBuilder")
    private OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder;

    @Test
    public void verifyOperationForOidc() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("response_mode", OAuth20ResponseModeTypes.FORM_POST.getType());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        HashMap parameters = new HashMap();
        OidcRegisteredService registeredService = OidcAuthorizationModelAndViewBuilderTests.getOidcRegisteredService();
        ModelAndView results = this.oauthAuthorizationModelAndViewBuilder.build((WebContext)context, (OAuthRegisteredService)registeredService, "https://localhost:8443/app/redirect", parameters);
        Assertions.assertTrue((boolean)results.getModel().containsKey("originalUrl"));
        String url = results.getModel().get("originalUrl").toString();
        Assertions.assertTrue((boolean)url.contains("iss".concat("=")));
        Map params = (Map)results.getModel().get("parameters");
        Assertions.assertTrue((boolean)params.containsKey("iss"));
    }

    @Test
    public void verifyOperationForNonOidc() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        HashMap parameters = new HashMap();
        OAuthRegisteredService registeredService = OidcAuthorizationModelAndViewBuilderTests.getOAuthRegisteredService(UUID.randomUUID().toString(), "https://localhost:8443/app/redirect");
        ModelAndView results = this.oauthAuthorizationModelAndViewBuilder.build((WebContext)context, registeredService, "https://localhost:8443/app/redirect", parameters);
        RedirectView view = (RedirectView)results.getView();
        Assertions.assertEquals((Object)"https://localhost:8443/app/redirect", (Object)view.getUrl());
    }
}

