/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.url.UrlResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcCasCallbackUrlResolverTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="casCallbackUrlResolver")
    private UrlResolver casCallbackUrlResolver;

    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("client_id", UUID.randomUUID().toString());
        request.addParameter("state", UUID.randomUUID().toString());
        request.addParameter("ui_locales", "de");
        request.addParameter("max_age", "100");
        String output = this.casCallbackUrlResolver.compute(OAuth20Utils.casOAuthCallbackUrl((String)this.casProperties.getServer().getPrefix()), (WebContext)new JEEContext((HttpServletRequest)request, (HttpServletResponse)response));
        Assertions.assertNotNull((Object)output);
        URIBuilder uri = new URIBuilder(output);
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("client_id")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("state")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("ui_locales")));
        Assertions.assertTrue((boolean)uri.getQueryParams().stream().anyMatch(p -> p.getName().equalsIgnoreCase("max_age")));
    }
}

