/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcConsentApprovalViewResolverTests
extends AbstractOidcTests {
    @Test
    public void verifyBypassedBySession() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        JEESessionStore.INSTANCE.set((WebContext)context, "bypass_approval_prompt", (Object)"true");
        OAuthRegisteredService service = OidcConsentApprovalViewResolverTests.getOAuthRegisteredService(UUID.randomUUID().toString(), "https://google.com");
        Assertions.assertNotNull((Object)this.consentApprovalViewResolver.resolve(context, service));
    }

    @Test
    public void verifyBypassedByPrompt() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://cas.org/something");
        request.setQueryString("prompt=consent");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        Assertions.assertNotNull((Object)this.consentApprovalViewResolver.resolve(context, (OAuthRegisteredService)service));
    }

    @Test
    public void verifyBypassedWithoutPrompt() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("https://cas.org/something");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService service = OidcConsentApprovalViewResolverTests.getOidcRegisteredService(UUID.randomUUID().toString());
        Assertions.assertNotNull((Object)this.consentApprovalViewResolver.resolve(context, (OAuthRegisteredService)service));
    }
}

