/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.dynamicClientRegistrationMode=PROTECTED"})
public class OidcHandlerInterceptorAdapterTests
extends AbstractOidcTests {
    @Test
    public void verifyNothing() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertTrue((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyNoOIDC() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/device");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyConfigUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }

    @Test
    public void verifyRegUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/register");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertFalse((boolean)this.oauthInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object()));
    }
}

