/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
public class OidcImplicitIdTokenAndTokenAuthorizationResponseBuilderTests
extends AbstractOidcTests {
    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("response_type", OAuth20ResponseTypes.IDTOKEN_TOKEN.getType());
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertTrue((boolean)this.oidcImplicitIdTokenAndTokenCallbackUrlBuilder.supports((WebContext)context));
    }

    @Test
    public void verifyBuild() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("state", Collections.singletonList("state"));
        attributes.put("nonce", Collections.singletonList("nonce"));
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        OidcRegisteredService registeredService = OidcImplicitIdTokenAndTokenAuthorizationResponseBuilderTests.getOidcRegisteredService(UUID.randomUUID().toString());
        OAuth20Code code = this.addCode(principal, (OAuthRegisteredService)registeredService);
        AccessTokenRequestDataHolder holder = AccessTokenRequestDataHolder.builder().token((OAuth20Token)code).clientId(registeredService.getClientId()).service(CoreAuthenticationTestUtils.getService()).authentication(RegisteredServiceTestUtils.getAuthentication((Principal)principal, attributes)).registeredService((OAuthRegisteredService)registeredService).grantType(OAuth20GrantTypes.AUTHORIZATION_CODE).responseType(OAuth20ResponseTypes.CODE).ticketGrantingTicket((TicketGrantingTicket)new MockTicketGrantingTicket("casuser")).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("response_type", OAuth20ResponseTypes.IDTOKEN_TOKEN.getType());
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)JEESessionStore.INSTANCE);
        CommonProfile profile = new CommonProfile();
        profile.setClientName("clientBasicAuth");
        profile.setId("casuser");
        manager.save(true, (UserProfile)profile, false);
        this.servicesManager.save((RegisteredService)registeredService);
        ModelAndView mv = this.oidcImplicitIdTokenAndTokenCallbackUrlBuilder.build((WebContext)context, registeredService.getClientId(), holder);
        Assertions.assertNotNull((Object)mv);
    }
}

