/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Tag(value="OIDC")
public class OidcLocaleChangeInterceptorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcLocaleChangeInterceptor")
    private HandlerInterceptor oidcLocaleChangeInterceptor;

    @Test
    public void verifyOperation() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE, (Object)new SessionLocaleResolver());
        this.oidcLocaleChangeInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object());
        Assertions.assertNull((Object)request.getAttribute(Locale.class.getName()));
        String service = "https://localhost/cas/authz?ui_locales=de";
        request.addParameter("service", "https://localhost/cas/authz?ui_locales=de");
        this.oidcLocaleChangeInterceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, new Object());
        Assertions.assertNotNull((Object)request.getAttribute(Locale.class.getName()));
    }
}

