/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.introspection.OidcIntrospectionEndpointController;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.EncodingUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcIntrospectionEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcIntrospectionEndpointController")
    protected OidcIntrospectionEndpointController oidcIntrospectionEndpointController;

    @Test
    public void verifyOperationWithValidTicket() {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String auth = "clientid:secret";
        String value = EncodingUtils.encodeBase64((byte[])"clientid:secret".getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuth20AccessToken accessToken = this.getAccessToken();
        this.servicesManager.save((RegisteredService)OidcIntrospectionEndpointControllerTests.getOidcRegisteredService());
        this.ticketRegistry.addTicket((Ticket)accessToken);
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertNotNull((Object)result.getBody());
        Assertions.assertTrue((boolean)Instant.ofEpochSecond(((OAuth20IntrospectionAccessTokenResponse)result.getBody()).getExp()).isAfter(Instant.ofEpochSecond(((OAuth20IntrospectionAccessTokenResponse)result.getBody()).getIat())));
        Assertions.assertTrue((boolean)((OAuth20IntrospectionAccessTokenResponse)result.getBody()).isActive());
        Assertions.assertEquals((Object)accessToken.getScopes(), Set.of(((OAuth20IntrospectionAccessTokenResponse)result.getBody()).getScope().split(" ")));
    }

    @Test
    public void verifyBadEndpointRequest() {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatusCode());
    }

    @Test
    public void verifyOperationWithInvalidTicket() {
        MockHttpServletRequest request = OidcIntrospectionEndpointControllerTests.getHttpRequestForEndpoint("introspect");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String auth = "clientid:secret";
        String value = EncodingUtils.encodeBase64((byte[])"clientid:secret".getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", (Object)("Basic " + value));
        OAuth20AccessToken accessToken = this.getAccessToken();
        this.servicesManager.save((RegisteredService)OidcIntrospectionEndpointControllerTests.getOidcRegisteredService());
        request.addParameter("token", accessToken.getId());
        ResponseEntity result = this.oidcIntrospectionEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)result.getStatusCode());
        Assertions.assertNotNull((Object)result.getBody());
        Assertions.assertFalse((boolean)((OAuth20IntrospectionAccessTokenResponse)result.getBody()).isActive());
    }
}

