/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Tag(value="OIDC")
public class OidcAuthorizeEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcAuthorizeController")
    protected OidcAuthorizeEndpointController oidcAuthorizeEndpointController;

    @Test
    public void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcAuthorizeEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatus());
    }

    @Test
    public void verify() throws Exception {
        String id = UUID.randomUUID().toString();
        MockHttpServletRequest mockRequest = OidcAuthorizeEndpointControllerTests.getHttpRequestForEndpoint("oidcAuthorize");
        mockRequest.setMethod(HttpMethod.GET.name());
        mockRequest.setParameter("client_id", id);
        mockRequest.setParameter("redirect_uri", "https://oauth.example.org/");
        mockRequest.setParameter("response_type", OAuth20ResponseTypes.TOKEN.name().toLowerCase());
        mockRequest.setContextPath("");
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        OidcConfigurationContext oauthContext = (OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext();
        oauthContext.getCasProperties().getSessionReplication().getCookie().setAutoConfigureCookiePath(false);
        oauthContext.getOauthDistributedSessionCookieGenerator().setCookiePath("");
        OidcRegisteredService service = OidcAuthorizeEndpointControllerTests.getOidcRegisteredService(id);
        service.setBypassApprovalPrompt(true);
        this.servicesManager.save((RegisteredService)service);
        CasProfile profile = new CasProfile();
        profile.setId("casuser");
        SessionStore sessionStore = ((OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext()).getSessionStore();
        JEEContext context = new JEEContext((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        MockTicketGrantingTicket ticket = new MockTicketGrantingTicket("casuser");
        ((OidcConfigurationContext)this.oidcAuthorizeEndpointController.getConfigurationContext()).getTicketRegistry().addTicket((Ticket)ticket);
        sessionStore.set((WebContext)context, "ticketGrantingTicketId", (Object)ticket.getId());
        sessionStore.set((WebContext)context, "pac4jUserProfiles", (Object)CollectionUtils.wrapLinkedHashMap((String)profile.getClientName(), (Object)profile));
        ModelAndView modelAndView = this.oidcAuthorizeEndpointController.handleRequest((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        View view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
        modelAndView = this.oidcAuthorizeEndpointController.handleRequestPost((HttpServletRequest)mockRequest, (HttpServletResponse)mockResponse);
        view = modelAndView.getView();
        Assertions.assertTrue((boolean)(view instanceof RedirectView));
    }
}

