/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.dynareg.OidcClientConfigurationEndpointController;
import org.apereo.cas.services.RegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcClientConfigurationEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcClientConfigurationEndpointController")
    protected OidcClientConfigurationEndpointController controller;

    @Test
    public void verifyBadEndpointRequest() {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.controller.handleRequestInternal("", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatusCode());
    }

    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        this.servicesManager.save((RegisteredService)OidcClientConfigurationEndpointControllerTests.getOidcRegisteredService(clientId));
        Assertions.assertEquals((int)200, (int)this.controller.handleRequestInternal(clientId, (HttpServletRequest)request, (HttpServletResponse)response).getStatusCodeValue());
    }

    @Test
    public void verifyBadRequest() {
        MockHttpServletRequest request = OidcClientConfigurationEndpointControllerTests.getHttpRequestForEndpoint("clientConfig");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String clientId = UUID.randomUUID().toString();
        Assertions.assertEquals((int)400, (int)this.controller.handleRequestInternal(clientId, (HttpServletRequest)request, (HttpServletResponse)response).getStatusCodeValue());
    }
}

