/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.jwks;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.jwks.OidcJwksEndpointController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;

@Tag(value="OIDC")
public class OidcJwksEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcJwksController")
    protected OidcJwksEndpointController oidcJwksEndpointController;

    @Test
    public void verifyOperation() {
        ExtendedModelMap model = new ExtendedModelMap();
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("jwks");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response, (Model)model);
        Assertions.assertTrue((boolean)result.getStatusCode().is2xxSuccessful());
    }

    @Test
    public void verifyBadEndpointRequest() {
        ExtendedModelMap model = new ExtendedModelMap();
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, (HttpServletResponse)response, (Model)model);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatusCode());
    }

    @Test
    public void verifyFails() {
        ExtendedModelMap model = new ExtendedModelMap();
        MockHttpServletRequest request = OidcJwksEndpointControllerTests.getHttpRequestForEndpoint("jwks");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ((HttpServletResponse)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)response)).setContentType(Mockito.anyString());
        ResponseEntity result = this.oidcJwksEndpointController.handleRequestInternal((HttpServletRequest)request, response, (Model)model);
        Assertions.assertTrue((boolean)result.getStatusCode().is4xxClientError());
    }
}

