/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.logout;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.logout.OidcLogoutEndpointController;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.support.WebUtils;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
public class OidcLogoutEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcLogoutEndpointController")
    protected OidcLogoutEndpointController oidcLogoutEndpointController;
    @Autowired
    @Qualifier(value="oidcProtocolEndpointConfigurer")
    private ProtocolEndpointWebSecurityConfigurer<Void> oidcProtocolEndpointConfigurer;

    @Test
    public void verifyEndpoints() {
        Assertions.assertFalse((boolean)this.oidcProtocolEndpointConfigurer.getIgnoredEndpoints().isEmpty());
    }

    @Test
    public void verifyBadEndpointRequest() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity mv = this.oidcLogoutEndpointController.handleRequestInternal("", "", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatusCode());
    }

    @Test
    public void verifyOidcNoLogoutUrls() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String id = UUID.randomUUID().toString();
        JwtClaims claims = this.getClaims(id);
        OidcRegisteredService oidcRegisteredService = new OidcRegisteredService();
        oidcRegisteredService.setClientId(id);
        this.servicesManager.save((RegisteredService)oidcRegisteredService);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
    }

    @Test
    public void verifyOidcLogoutWithoutParams() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertNull((Object)redirectUrl);
    }

    @Test
    public void verifyOidcLogoutWithStateParam() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "abcd1234", "", (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertNull((Object)redirectUrl);
    }

    @Test
    public void verifyOidcLogoutWithIdTokenParam() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?client_id=clientid", (Object)redirectUrl);
    }

    @Test
    public void verifyOidcLogoutWithIdTokenAndStateParams() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }

    @Test
    public void verifyOidcLogoutWithIdTokenAndValidPostLogoutRedirectUrlParams() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("https://logout", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }

    @Test
    public void verifyOidcLogoutWithIdTokenAndInvalidPostLogoutRedirectUrlParams() {
        MockHttpServletRequest request = OidcLogoutEndpointControllerTests.getHttpRequestForEndpoint("oidcLogout");
        MockHttpServletResponse response = new MockHttpServletResponse();
        JwtClaims claims = this.getClaims();
        OidcRegisteredService oidcRegisteredService = OidcLogoutEndpointControllerTests.getOidcRegisteredService(true, false);
        String idToken = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)oidcRegisteredService, claims);
        ResponseEntity result = this.oidcLogoutEndpointController.handleRequestInternal("https://invalidlogouturl", "abcd1234", idToken, (HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)HttpStatus.PERMANENT_REDIRECT.value(), (int)result.getStatusCodeValue());
        String redirectUrl = (String)WebUtils.getLogoutRedirectUrl((HttpServletRequest)request, String.class);
        Assertions.assertEquals((Object)"https://oauth.example.org/logout?state=abcd1234&client_id=clientid", (Object)redirectUrl);
    }
}

