/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.web.controllers.token.OidcAccessTokenEndpointController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="OIDC")
public class OidcAccessTokenEndpointControllerTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcAccessTokenController")
    protected OidcAccessTokenEndpointController oidcAccessTokenEndpointController;

    @Test
    public void verifyBadEndpointRequest() throws Exception {
        MockHttpServletRequest request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("unknown/issuer");
        request.setRequestURI("unknown/issuer");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.oidcAccessTokenEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)mv.getStatus());
    }

    @Test
    public void verifyClientNoCode() throws Exception {
        MockHttpServletRequest request = OidcAccessTokenEndpointControllerTests.getHttpRequestForEndpoint("oidcAccessToken");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.oidcAccessTokenEndpointController.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)400, (int)response.getStatus());
        this.oidcAccessTokenEndpointController.handleGetRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }
}

