/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="OIDC")
public class OidcCasWebflowLoginContextProviderTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcCasWebflowLoginContextProvider")
    private CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider;

    @Test
    public void verifyOperation() {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        Assertions.assertTrue((boolean)this.oidcCasWebflowLoginContextProvider.getCandidateUsername((RequestContext)context).isEmpty());
        request.addParameter("service", "https://localhost/cas?service=https://example.net&login_hint=casuser");
        Assertions.assertTrue((boolean)this.oidcCasWebflowLoginContextProvider.getCandidateUsername((RequestContext)context).isPresent());
    }
}

