/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
public class OidcMultifactorAuthenticationTriggerTests {

    @Nested
    @Import(value={OidcAuthenticationContextTestConfiguration.class})
    public class WithMultifactorProvidersTests
    extends AbstractOidcTests {
        @Test
        public void verifyNoAcr() {
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            MockHttpServletRequest request = new MockHttpServletRequest();
            Authentication authn = RegisteredServiceTestUtils.getAuthentication();
            AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
            Assertions.assertTrue((boolean)this.oidcMultifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)registeredService, (HttpServletRequest)request, (Service)service).isEmpty());
        }

        @Test
        public void verifyAcrMfa() {
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("service", String.format("https://app.org?%s=mfa-dummy", "acr_values"));
            Authentication authn = RegisteredServiceTestUtils.getAuthentication();
            AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
            Assertions.assertFalse((boolean)this.oidcMultifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)registeredService, (HttpServletRequest)request, (Service)service).isEmpty());
        }

        @Test
        public void verifyUrlEncoding() {
            String url = "https://link.test.edu/web/cas?profile=Example Primo&targetURL=abc";
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setRequestURI("/cas/login");
            request.addParameter("service", "https://link.test.edu/web/cas?profile=Example Primo&targetURL=abc");
            Authentication authn = RegisteredServiceTestUtils.getAuthentication();
            AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"https://link.test.edu/web/cas?profile=Example Primo&targetURL=abc");
            Assertions.assertTrue((boolean)this.oidcMultifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)registeredService, (HttpServletRequest)request, (Service)service).isEmpty());
        }
    }

    @Nested
    @Import(value={OidcAuthenticationContextTestConfiguration.class})
    @TestPropertySource(properties={"cas.authn.oidc.core.authentication-context-reference-mappings=1->mfa-dummy"})
    public class WithMappedMultifactorProvidersTests
    extends AbstractOidcTests {
        @Test
        public void verifyAcrMfa() {
            TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("service", String.format("https://app.org?%s=1 2", "acr_values"));
            Authentication authn = RegisteredServiceTestUtils.getAuthentication();
            AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
            Assertions.assertTrue((boolean)this.oidcMultifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)registeredService, (HttpServletRequest)request, (Service)service).isPresent());
        }
    }

    @Nested
    public class NoMultifactorProvidersTests
    extends AbstractOidcTests {
        @Test
        public void verifyAcrMissingMfa() {
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addParameter("acr_values", "unknown");
            Authentication authn = RegisteredServiceTestUtils.getAuthentication();
            AbstractRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
            Assertions.assertThrows(AuthenticationException.class, () -> this.oidcMultifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)registeredService, (HttpServletRequest)request, (Service)service));
        }
    }

    @TestConfiguration(value="OidcAuthenticationContextTestConfiguration")
    public static class OidcAuthenticationContextTestConfiguration {
        @Bean
        public MultifactorAuthenticationProvider dummyProvider() {
            return new TestMultifactorAuthenticationProvider();
        }
    }
}

