/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcAccessTokenAuthenticatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauthAccessTokenAuthenticator")
    private Authenticator oauthAccessTokenAuthenticator;
    @Autowired
    @Qualifier(value="oidcDynamicRegistrationAuthenticator")
    private Authenticator oidcDynamicRegistrationAuthenticator;

    OidcAccessTokenAuthenticatorTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        new ProfileManager((WebContext)ctx, JEESessionStore.INSTANCE).removeProfiles();
        String token = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)OidcAccessTokenAuthenticatorTests.getOidcRegisteredService(), this.getClaims());
        OAuth20AccessToken at = this.getAccessToken(token, "clientid");
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        this.oauthAccessTokenAuthenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNotNull((Object)userProfile);
        Assertions.assertEquals((Object)"casuser", (Object)userProfile.getId());
        Assertions.assertTrue((boolean)userProfile.containsAttribute("client_id"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("sub"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("iss"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("exp"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("aud"));
        Assertions.assertTrue((boolean)userProfile.containsAttribute("email"));
    }

    @Test
    void verifyFailsOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        new ProfileManager((WebContext)ctx, JEESessionStore.INSTANCE).removeProfiles();
        OAuth20AccessToken at = this.getAccessToken("helloworld", "clientid");
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        this.oauthAccessTokenAuthenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    void verifyFailsMissingScopes() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        String token = this.oidcTokenSigningAndEncryptionService.encode((OAuthRegisteredService)OidcAccessTokenAuthenticatorTests.getOidcRegisteredService(), this.getClaims());
        OAuth20AccessToken at = this.getAccessToken(token, "clientid");
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        this.oidcDynamicRegistrationAuthenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }
}

