/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.authn.OidcClientConfigurationAccessTokenAuthenticator;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcClientConfigurationAccessTokenAuthenticatorTests
extends AbstractOidcTests {
    OidcClientConfigurationAccessTokenAuthenticatorTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        OAuth20AccessToken at = this.getAccessToken();
        Mockito.when((Object)at.getScopes()).thenReturn(Set.of("client_configuration_scope"));
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        this.getAuthenticator().validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNotNull((Object)userProfile);
        Assertions.assertEquals((Object)"casuser", (Object)userProfile.getId());
    }

    private OidcClientConfigurationAccessTokenAuthenticator getAuthenticator() {
        return new OidcClientConfigurationAccessTokenAuthenticator(this.oidcConfigurationContext.getTicketRegistry(), this.oidcAccessTokenJwtBuilder);
    }

    @Test
    void verifyFailsOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        OAuth20AccessToken at = this.getAccessToken();
        Mockito.when((Object)at.getScopes()).thenThrow(new Throwable[]{new IllegalArgumentException()});
        this.ticketRegistry.addTicket((Ticket)at);
        TokenCredentials credentials = new TokenCredentials(at.getId());
        this.getAuthenticator().validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        UserProfile userProfile = credentials.getUserProfile();
        Assertions.assertNull((Object)userProfile);
    }
}

