/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.core.user-defined-scopes.MyScope=uid", "cas.authn.oidc.discovery.scopes=openid,profile,email,MyScope", "cas.authn.oidc.discovery.claims=sub,name,family_name,given_name,uid"})
class OidcClientIdClientSecretAuthenticatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauthClientAuthenticator")
    private Authenticator authenticator;

    OidcClientIdClientSecretAuthenticatorTests() {
    }

    @Test
    void verifyWithoutRequestingScopes() {
        OidcRegisteredService registeredService = OidcClientIdClientSecretAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)registeredService);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(registeredService.getClientId(), registeredService.getClientSecret());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", registeredService.getClientId());
        request.addParameter("client_secret", registeredService.getClientSecret());
        request.addParameter("scope", "openid");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((int)1, (int)credentials.getUserProfile().getAttributes().size());
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("client_id"));
    }

    @Test
    void verifyWithRequestingScopes() {
        OidcRegisteredService registeredService = OidcClientIdClientSecretAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        registeredService.setScopes(Set.of("openid", "MyScope"));
        this.servicesManager.save((RegisteredService)registeredService);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(registeredService.getClientId(), registeredService.getClientSecret());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", registeredService.getClientId());
        request.addParameter("client_secret", registeredService.getClientSecret());
        request.addParameter("scope", "openid MyScope");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertEquals((int)2, (int)credentials.getUserProfile().getAttributes().size());
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("client_id"));
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("uid"));
    }
}

