/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.DefaultDPoPProofFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.UUID;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
class OidcDPoPAuthenticatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcDPoPClientProvider")
    private OAuth20AuthenticationClientProvider oidcDPoPClientProvider;

    OidcDPoPAuthenticatorTests() {
    }

    @Test
    void verifyOperation() throws Exception {
        OidcRegisteredService service = OidcDPoPAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)service);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", service.getClientId());
        request.setRequestURI("/cas/oidc");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        new ProfileManager((WebContext)ctx, JEESessionStore.INSTANCE).removeProfiles();
        ECKey ecJWK = (ECKey)new ECKeyGenerator(Curve.P_256).keyID("1").generate();
        DefaultDPoPProofFactory proofFactory = new DefaultDPoPProofFactory((JWK)ecJWK, JWSAlgorithm.ES256);
        SignedJWT proof = proofFactory.createDPoPJWT("POST", new URI(request.getRequestURL().toString()));
        request.addHeader("DPoP", (Object)proof.serialize());
        HeaderClient client = (HeaderClient)this.oidcDPoPClientProvider.createClient();
        TokenCredentials credentials = new TokenCredentials("DPoP");
        client.getAuthenticator().validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        UserProfile profile = credentials.getUserProfile();
        Assertions.assertNotNull((Object)profile);
        Assertions.assertNotNull((Object)profile.getAttribute("DPoP"));
        Assertions.assertNotNull((Object)profile.getAttribute("DPoPConfirmation"));
    }
}

