/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.oidc.jwks.OidcJsonWebKeystoreCoreProperties;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.util.EncodingUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oauth.code.time-to-kill-in-seconds=60", "cas.authn.oidc.jwks.file-system.jwks-file=file:${#systemProperties['java.io.tmpdir']}/private-jwks.jwks"})
class OidcJwtAuthenticatorRsaTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oidcJwtClientProvider")
    private OAuth20AuthenticationClientProvider oidcJwtClientProvider;

    OidcJwtAuthenticatorRsaTests() {
    }

    @Test
    void verifyAction() throws Exception {
        Authenticator auth = this.getAuthenticator();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService registeredService = OidcJwtAuthenticatorRsaTests.getOidcRegisteredService();
        registeredService.setClientId(UUID.randomUUID().toString());
        File file = File.createTempFile("jwks-service", ".jwks");
        OidcJsonWebKeystoreCoreProperties core = this.casProperties.getAuthn().getOidc().getJwks().getCore();
        PublicJsonWebKey jsonWebKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey((String)core.getJwksType(), (int)core.getJwksKeySize(), (OidcJsonWebKeyUsage)OidcJsonWebKeyUsage.SIGNING);
        jsonWebKey.setKeyId("cas-kid");
        JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{jsonWebKey});
        String data = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        FileUtils.write((File)file, (CharSequence)data, (Charset)StandardCharsets.UTF_8);
        registeredService.setJwks("file://" + file.getAbsolutePath());
        this.servicesManager.save((RegisteredService)registeredService);
        JwtClaims claims = this.getClaims(registeredService.getClientId(), this.oidcIssuerService.determineIssuer(Optional.of(registeredService)), registeredService.getClientId(), registeredService.getClientId());
        JsonWebKeySet webKeys = (JsonWebKeySet)((Optional)this.oidcServiceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)registeredService, OidcJsonWebKeyUsage.SIGNING))).get();
        PublicJsonWebKey key = (PublicJsonWebKey)webKeys.getJsonWebKeys().get(0);
        byte[] jwt = EncodingUtils.signJwsRSASha512((Key)key.getPrivateKey(), (byte[])claims.toJson().getBytes(StandardCharsets.UTF_8), Map.of());
        UsernamePasswordCredentials credentials = this.getCredential(request, "urn:ietf:params:oauth:client-assertion-type:jwt-bearer", new String(jwt, StandardCharsets.UTF_8), registeredService.getClientId());
        auth.validate(new CallContext((WebContext)context, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
    }

    @Test
    void verifyBadUser() throws Exception {
        Authenticator auth = this.getAuthenticator();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        OidcRegisteredService registeredService = OidcJwtAuthenticatorRsaTests.getOidcRegisteredService();
        UsernamePasswordCredentials credentials = this.getCredential(request, "unknown", "unknown", registeredService.getClientId());
        auth.validate(new CallContext((WebContext)context, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    @Test
    void verifyBadCred() {
        Authenticator auth = this.getAuthenticator();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        JEEContext context = new JEEContext((HttpServletRequest)request, (HttpServletResponse)response);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("urn:ietf:params:oauth:client-assertion-type:jwt-bearer", null);
        auth.validate(new CallContext((WebContext)context, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNull((Object)credentials.getUserProfile());
    }

    private Authenticator getAuthenticator() {
        BaseClient c = (BaseClient)this.oidcJwtClientProvider.createClient();
        return c.getAuthenticator();
    }

    private UsernamePasswordCredentials getCredential(MockHttpServletRequest request, String uid, String password, String clientId) throws Exception {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(uid, password);
        OAuth20Code code = this.defaultOAuthCodeFactory.create((Service)RegisteredServiceTestUtils.getService(), RegisteredServiceTestUtils.getAuthentication(), (TicketGrantingTicket)new MockTicketGrantingTicket("casuser"), new ArrayList(), "", "", clientId, new HashMap(), OAuth20ResponseTypes.CODE, OAuth20GrantTypes.AUTHORIZATION_CODE);
        this.ticketRegistry.addTicket((Ticket)code);
        request.addParameter("code", code.getId());
        return credentials;
    }
}

