/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="OIDC")
@Import(value={AuthenticationTestConfiguration.class})
class OidcUsernamePasswordAuthenticatorTests
extends AbstractOidcTests {
    @Autowired
    @Qualifier(value="oauthUserAuthenticator")
    private Authenticator authenticator;

    OidcUsernamePasswordAuthenticatorTests() {
    }

    @Test
    void verifyClientIdWithoutAnyAttributes() {
        OidcRegisteredService registeredService = OidcUsernamePasswordAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)registeredService);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("oidctest", "oidctest");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", registeredService.getClientId());
        request.addParameter("client_secret", registeredService.getClientSecret());
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().isEmpty());
    }

    @Test
    void verifyClientIdWithScopesRequest() {
        OidcRegisteredService registeredService = OidcUsernamePasswordAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)registeredService);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("oidctest", "oidctest");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", registeredService.getClientId());
        request.addParameter("client_secret", registeredService.getClientSecret());
        request.addParameter("scope", "openid profile email");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("email"));
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("family_name"));
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().containsKey("given_name"));
    }

    @Test
    void verifyClientIdWithoutScopesRequest() {
        OidcRegisteredService registeredService = OidcUsernamePasswordAuthenticatorTests.getOidcRegisteredService(UUID.randomUUID().toString());
        this.servicesManager.save((RegisteredService)registeredService);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("oidctest", "oidctest");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("client_id", registeredService.getClientId());
        request.addParameter("client_secret", registeredService.getClientSecret());
        request.addParameter("scope", "openid");
        JEEContext ctx = new JEEContext((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        this.authenticator.validate(new CallContext((WebContext)ctx, JEESessionStore.INSTANCE), (Credentials)credentials);
        Assertions.assertNotNull((Object)credentials.getUserProfile());
        Assertions.assertTrue((boolean)credentials.getUserProfile().getAttributes().isEmpty());
    }

    @Tag(value="OAuth")
    @TestConfiguration(value="AuthenticationTestConfiguration", proxyBeanMethods=false)
    static class AuthenticationTestConfiguration
    implements AuthenticationEventExecutionPlanConfigurer {
        AuthenticationTestConfiguration() {
        }

        public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
            SimpleTestUsernamePasswordAuthenticationHandler handler = new SimpleTestUsernamePasswordAuthenticationHandler();
            handler.putAttributes(CoreAuthenticationTestUtils.getAttributes());
            handler.putAttribute("family_name", List.of("Apereo")).putAttribute("given_name", List.of("CAS")).putAttribute("email", List.of("cas@apereo.org"));
            plan.registerAuthenticationHandler((AuthenticationHandler)handler);
        }
    }
}

