/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="OIDC")
class OidcAddressScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    OidcAddressScopeAttributeReleasePolicyTests() {
    }

    @Test
    void verifyOperation() {
        OidcAddressScopeAttributeReleasePolicy policy = new OidcAddressScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.ADDRESS.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"name", List.of("cas"), (String)"address", List.of("Main St")));
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(releasePolicyContext).containsAll(policy.getAllowedAttributes()));
    }

    @Test
    void verifySerialization() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        OidcAddressScopeAttributeReleasePolicy policy = new OidcAddressScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
        OidcRegisteredService service = OidcAddressScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

