/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.authn.oidc.discovery.claims=sub,name,given_name,family_name,middle_name,preferred_username,email,mail,groups"})
@Tag(value="OIDC")
class OidcCustomScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    OidcCustomScopeAttributeReleasePolicyTests() {
    }

    @Test
    void verifyOperation() {
        OidcCustomScopeAttributeReleasePolicy policy = new OidcCustomScopeAttributeReleasePolicy("groups", CollectionUtils.wrap((Object)"groups"));
        Assertions.assertEquals((Object)"custom", (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"groups", List.of("admin", "user")));
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Principal principal2 = CoreAuthenticationTestUtils.getPrincipal((Map)attrs);
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext2 = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal2).build();
        Map releaseAttrs = policy.getAttributes(releasePolicyContext2);
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(releaseAttrs::containsKey));
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().containsAll(policy.determineRequestedAttributeDefinitions(releasePolicyContext2)));
        Assertions.assertEquals(List.of("admin", "user"), releaseAttrs.get("groups"));
    }

    @Test
    void verifyGroovyMappingInline() {
        ApplicationContextProvider.holdApplicationContext((ApplicationContext)this.oidcConfigurationContext.getApplicationContext());
        OidcCustomScopeAttributeReleasePolicy policy = new OidcCustomScopeAttributeReleasePolicy("groups", CollectionUtils.wrap((Object)"groups"));
        policy.setClaimMappings(Map.of("groups", "groovy { return attributes['groups'] }"));
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"groups", List.of("admin", "user")));
        OidcRegisteredService oidcRegisteredService = OidcCustomScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        oidcRegisteredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)oidcRegisteredService).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertEquals(List.of("admin", "user"), attrs.get("groups"));
    }

    @Test
    void verifySerialization() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        OidcCustomScopeAttributeReleasePolicy policy = new OidcCustomScopeAttributeReleasePolicy("groups", CollectionUtils.wrap((Object)"groups"));
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
        OidcRegisteredService service = OidcCustomScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

