/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcDefaultAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
class OidcDefaultAttributeToScopeClaimMapperTests {
    OidcDefaultAttributeToScopeClaimMapperTests() {
    }

    @TestPropertySource(properties={"cas.authn.oidc.core.claims-map.email=mail", "cas.authn.oidc.core.claims-map.email_verified=mail_confirmed"})
    @Nested
    class DefaultTests
    extends AbstractOidcTests {
        DefaultTests() {
        }

        @Test
        void verifyValueTypes() {
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService();
            OidcDefaultAttributeToScopeClaimMapper mapper = new OidcDefaultAttributeToScopeClaimMapper(CollectionUtils.wrap((String)"active1", (Object)"status1", (String)"active2", (Object)"status2", (String)"active3", (Object)"status3"));
            Principal principal = RegisteredServiceTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"status1", (Object)"true", (String)"status2", (Object)false, (String)"status3", (Object)1));
            Object value = mapper.mapClaim("active1", (RegisteredService)oidcRegisteredService, principal, null).get(0);
            Assertions.assertTrue((boolean)(value instanceof Boolean));
            value = mapper.mapClaim("active2", (RegisteredService)oidcRegisteredService, principal, null).get(0);
            Assertions.assertTrue((boolean)(value instanceof Boolean));
            value = mapper.mapClaim("active3", (RegisteredService)oidcRegisteredService, principal, null).get(0);
            Assertions.assertTrue((boolean)(value instanceof Number));
        }

        @Test
        void verifyOperation() {
            OidcDefaultAttributeToScopeClaimMapper mapper = new OidcDefaultAttributeToScopeClaimMapper(CollectionUtils.wrap((String)"name", (Object)"givenName"));
            OidcRegisteredService oidcRegisteredService = DefaultTests.getOidcRegisteredService();
            Assertions.assertTrue((boolean)mapper.containsMappedAttribute("name", (RegisteredService)oidcRegisteredService));
            Assertions.assertEquals((Object)"givenName", (Object)mapper.getMappedAttribute("name", (RegisteredService)oidcRegisteredService));
        }

        @Test
        void verifyClaimMapOperation() {
            OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
            Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
            Assertions.assertNotNull((Object)policy.getAllowedAttributes());
            Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"mail", List.of("cas@example.org"), (String)"mail_confirmed", List.of("cas@example.org")));
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
            Map attrs = policy.getAttributes(releasePolicyContext);
            Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
            Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(releasePolicyContext).containsAll(policy.getAllowedAttributes()));
        }
    }

    @Nested
    class ClaimMappingTests
    extends AbstractOidcTests {
        ClaimMappingTests() {
        }

        @Test
        void verifyOperation() {
            OidcDefaultAttributeToScopeClaimMapper mapper = new OidcDefaultAttributeToScopeClaimMapper(Map.of());
            OidcRegisteredService service = ClaimMappingTests.getOidcRegisteredService();
            OidcProfileScopeAttributeReleasePolicy policy = new OidcProfileScopeAttributeReleasePolicy();
            policy.setClaimMappings(Map.of("name", "givenName"));
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
            Assertions.assertTrue((boolean)mapper.containsMappedAttribute("name", (RegisteredService)service));
            Assertions.assertEquals((Object)"givenName", (Object)mapper.getMappedAttribute("name", (RegisteredService)service));
        }

        @Test
        void verifyChainOperation() {
            OidcDefaultAttributeToScopeClaimMapper mapper = new OidcDefaultAttributeToScopeClaimMapper(Map.of());
            OidcRegisteredService service = ClaimMappingTests.getOidcRegisteredService();
            OidcProfileScopeAttributeReleasePolicy policy = new OidcProfileScopeAttributeReleasePolicy();
            policy.setClaimMappings(Map.of("name", "givenName"));
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ChainingAttributeReleasePolicy().addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy}));
            Assertions.assertTrue((boolean)mapper.containsMappedAttribute("name", (RegisteredService)service));
            Assertions.assertEquals((Object)"givenName", (Object)mapper.getMappedAttribute("name", (RegisteredService)service));
        }
    }
}

