/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.oidc.AbstractOidcTests;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.test.context.TestPropertySource;

@Tag(value="OIDC")
@TestPropertySource(properties={"cas.authn.oidc.core.claims-map.email=mail", "cas.authn.oidc.core.claims-map.email_verified=mail_confirmed"})
class OidcEmailScopeAttributeReleasePolicyTests
extends AbstractOidcTests {
    OidcEmailScopeAttributeReleasePolicyTests() {
    }

    @Test
    void verifyOperation() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"email", List.of("cas@example.org"), (String)"email_verified", List.of("cas@example.org")));
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertTrue((boolean)policy.getAllowedAttributes().stream().allMatch(attrs::containsKey));
        Assertions.assertTrue((boolean)policy.determineRequestedAttributeDefinitions(releasePolicyContext).containsAll(policy.getAllowedAttributes()));
    }

    @Test
    void verifyClaimMapOperation() {
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        Assertions.assertEquals((Object)OidcConstants.StandardScopes.EMAIL.getScope(), (Object)policy.getScopeType());
        Assertions.assertNotNull((Object)policy.getAllowedAttributes());
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"mail", List.of("cas@example.org"), (String)"mail_confirmed", List.of("cas@example.org"), (String)"phone", List.of("0000000000")));
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(principal).build();
        Map attrs = policy.getAttributes(releasePolicyContext);
        Assertions.assertEquals(List.of("cas@example.org"), attrs.get("email"));
        Assertions.assertEquals(List.of("cas@example.org"), attrs.get("email_verified"));
        Assertions.assertFalse((boolean)attrs.containsKey("phone"));
        Principal serviceTicketPrincipal = CoreAuthenticationTestUtils.getPrincipal((Map)attrs);
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext2 = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService()).principal(serviceTicketPrincipal).build();
        Map releaseAttrs = policy.getAttributes(releasePolicyContext2);
        Assertions.assertEquals(List.of("cas@example.org"), releaseAttrs.get("email"));
        Assertions.assertEquals(List.of("cas@example.org"), releaseAttrs.get("email_verified"));
        Assertions.assertFalse((boolean)releaseAttrs.containsKey("phone"));
    }

    @Test
    void verifySerialization() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        OidcEmailScopeAttributeReleasePolicy policy = new OidcEmailScopeAttributeReleasePolicy();
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{policy});
        OidcRegisteredService service = OidcEmailScopeAttributeReleasePolicyTests.getOidcRegisteredService();
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)chain);
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)appCtx);
        String json = serializer.toString((Object)service);
        Assertions.assertNotNull((Object)json);
        Assertions.assertNotNull((Object)serializer.from(json));
    }
}

